export let translate = "en";

export const translations = {
  //English
  en: {
    websiteLink: "https://rf-sparta.com/site",
    gamecpLink: "https://rf-sparta.com/dashboard",
    discordLink: "https://discord.com/invite/yCz7cc38RM",
    registerLink: "https://rf-sparta.com",
    newsLinks: [
      "https://rf-sparta.com/site",
      "https://forum.rf-sparta.com/",
      "https://discord.com/invite/yCz7cc38RM",
    ],

    siteLink: "Website",
    cpLink: "Account",
    settingsButton: "Settings",
    playButton: "PLAY",
    playButton_Check: "CHECKING",
    playButton_DOWN: "LOADING",
    playButton_ENTER: "ENTER...",
    closeButton: "Close",
    authTitle: "Authorization",
    newUserAccLoginPlaceholder: "Enter login",
    newUserAccPassPlaceholder: "Enter password",
    addUserButton: "Add Account",
    goRegisterLink: "I don't have an account",
    closeShowErrorLink: "Close",
    closeEditAccountLink: "Close",
    editAccountTitle: "Edit acount",
    editAccountLoginPlaceholder: "Enter login",
    editAccountPasswordPlaceholder: "Enter password",
    editAccountButton: "Edit Data",
    deleteAccountButton: "Delete Account",
    settingsTitle: "Settings",
    graphicSettingsItem: "Graphics Settings",
    gameSettingsItem: "Game Settings",
    graphicSettingsTitle: "Graphics Settings",
    screenResolutionLabel: "Screen Resolution:",
    playInWindowLabel: "Play in Window:",
    gammaLabel: "Gamma:",
    dynamicLightingLabel: "Dynamic Lighting:",
    textureDetailLabel: "Texture Detail:",
    shadowQualityLabel: "Shadow Quality:",
    detailTexturesLabel: "Detail Textures:",
    performanceLabel: "Performance:",
    gameSettingsTitle: "Game Settings",
    gameLanguageLabel: "Game Language:",
    proxyServerLabel: "Proxy Server:",
    enableSoundsLabel: "Enable Sounds:",
    enableMusicLabel: "Enable Music:",
    mouseAccelerationLabel: "Mouse Acceleration:",
    cameraDistanceLabel: "Camera Distance:",
    fovLabel: "FOV:",
    enableTabTargetLabel: "Enable Tab Target:",
    pvpKillNotificationLabel: "PVP Kill Notification:",
    screenShakeLabel: "Screen Shake:",
    cancelButton: "Cancel",
    saveSettingsButton: "Save Settings",
    repairSettingsButton: "Repair",
    accountReadyGame:
      "Account is already ingame. Would you like to continue connection ?",
    accountReadyGameYes: "Yes",
    accountReadyGameNo: "No",
    barChecking: "Checking",
    barDownloading: "Downloading",
    barDownloadSpeed: "Download Speed",
    barReady: "Ready",
    launcherClose: "Close launcher",
    launcherCloseTip:
      "Checking the box will close the Launcher after the game starts.",

    connectionError3: "Account Banned",
    connectionError4: "Wrong Login",
    connectionError5: "Wrong Password",
    connectionError6: "Login Server Closed",
    connectionError7: "Network Error",
    connectionError10: "Billing Status Error",
    connectionError11: "Empty Result",
    connectionError97: "Unable to connect to update server",
    connectionError98: "Unable to connect to login server",
    connectionError99: "No active account selected",

    sliderTitles: ["OBT January 09 18:00 MSK", "FORUM", "DISCORD"],
    sliderTexts: [
      "RF SPARTA — HERE AND NOW!",
      "All the latest info — on our forum",
      "Join the RF SPARTA Discord community",
    ],
    sliderButtons: ["START PLAYING", "GO TO FORUM", "JOIN COMMUNITY"],
  },
  //Russian
  ru: {
    websiteLink: "https://rf-sparta.com/site",
    gamecpLink: "https://rf-sparta.com/dashboard",
    discordLink: "https://discord.com/invite/yCz7cc38RM",
    registerLink: "https://rf-sparta.com",
    newsLinks: [
      "https://rf-sparta.com/site",
      "https://forum.rf-sparta.com/",
      "https://discord.com/invite/yCz7cc38RM",
    ],

    siteLink: "Сайт",
    cpLink: "Личный Кабинет",
    settingsButton: "Настройки",
    playButton: "ЗАПУСК",
    playButton_Check: "ПРОВЕРКА",
    playButton_DOWN: "ЗАГРУЗКА",
    playButton_ENTER: "ВХОД...",
    closeButton: "Закрыть",
    authTitle: "Авторизация",
    newUserAccLoginPlaceholder: "Введите логин",
    newUserAccPassPlaceholder: "Введите пароль",
    addUserButton: "Добавить аккаунт",
    goRegisterLink: "У меня нет аккаунта",
    closeShowErrorLink: "Закрыть",
    closeEditAccountLink: "Закрыть",
    editAccountTitle: "Редактирование аккаунта",
    editAccountLoginPlaceholder: "Введите логин",
    editAccountPasswordPlaceholder: "Введите пароль",
    editAccountButton: "Изменить данные",
    deleteAccountButton: "Удалить аккуант",
    settingsTitle: "Настройки",
    graphicSettingsItem: "Настройка графики",
    gameSettingsItem: "Настройка игры",
    graphicSettingsTitle: "Настройка графики",
    screenResolutionLabel: "Разрешение экрана:",
    playInWindowLabel: "Играть в окне:",
    gammaLabel: "Гамма:",
    dynamicLightingLabel: "Динамическое освещение:",
    textureDetailLabel: "Детализация текстур:",
    shadowQualityLabel: "Качество теней:",
    detailTexturesLabel: "Детальные текстуры:",
    performanceLabel: "Производительность:",
    gameSettingsTitle: "Настройка игры",
    gameLanguageLabel: "Язык игры:",
    proxyServerLabel: "Прокси сервер:",
    enableSoundsLabel: "Включить звуки:",
    enableMusicLabel: "Включить музыку:",
    mouseAccelerationLabel: "Ускорение мыши:",
    cameraDistanceLabel: "Отдаление камеры:",
    fovLabel: "FOV:",
    enableTabTargetLabel: "Включить таб-таргет:",
    pvpKillNotificationLabel: "Уведедомление об убийствах:",
    screenShakeLabel: "Тряска экрана:",
    cancelButton: "Отменить",
    saveSettingsButton: "Сохранить настройки",
    repairSettingsButton: "Исправить",
    accountReadyGame:
      "Данный игровой аккаунт уже в игре, Вы уверены что хотите продолжить подключение ?",
    accountReadyGameYes: "Да",
    accountReadyGameNo: "Нет",
    barChecking: "Проверка",
    barDownloading: "Загрузка",
    barDownloadSpeed: "Скорость",
    barReady: "Готово",
    launcherClose: "Закрывать лаунчер",
    launcherCloseTip:
      "Установив галочку, лаунчер будет закрываться после запуска игры.",

    connectionError3: "Аккаунт заблокирован",
    connectionError4: "Неверный Логин",
    connectionError5: "Неверный Пароль",
    connectionError6: "Сервер Авторизации Закрыт",
    connectionError7: "Ошибка Сети",
    connectionError10: "Ошибка Статуса Биллинга",
    connectionError11: "Пустой Результат",
    connectionError97: "Невозможно подключиться к серверу обновления",
    connectionError98: "Невозможно подключиться к серверу авторизации",
    connectionError99: "Не выбран аккаунт",

    sliderTitles: ["ОБТ 09 ЯНВАРЯ 18:00 МСК", "FORUM", "DISCORD"],
    sliderTexts: [
      "RF SPARTA — ЗДЕСЬ И СЕЙЧАС!",
      "Актуальная информация — на нашем форуме",
      "Присоединяйся к Discord-сообществу RF SPARTA",
    ],
    sliderButtons: ["НАЧАТЬ ИГРАТЬ", "ПЕРЕЙТИ НА ФОРУМ", "СТАТЬ СООБЩЕСТВОМ"],
  },

  //Korean
  kr: {
    websiteLink: "https://example.com",
    gamecpLink: "https://example.com",
    discordLink: "https://example.com",
    registerLink: "https://example.com",
    newsLinks: [
      "https://example.com",
      "https://example.com",
      "https://example.com",
    ],

    siteLink: "웹사이트",
    cpLink: "계정",
    settingsButton: "설정",
    playButton: "PLAY",
    playButton_Check: "CHECKING",
    playButton_DOWN: "LOADING",
    playButton_ENTER: "ENTER...",
    closeButton: "닫기",
    authTitle: "인증",
    newUserAccLoginPlaceholder: "로그인 입력",
    newUserAccPassPlaceholder: "비밀번호 입력",
    addUserButton: "계정 추가",
    goRegisterLink: "계정이 없습니다",
    closeShowErrorLink: "닫기",
    closeEditAccountLink: "닫기",
    editAccountTitle: "Edit acount",
    editAccountLoginPlaceholder: "로그인 입력",
    editAccountPasswordPlaceholder: "비밀번호 입력",
    editAccountButton: "계정 수정",
    deleteAccountButton: "계정 삭제",
    settingsTitle: "설정",
    graphicSettingsItem: "그래픽 설정",
    gameSettingsItem: "게임 설정",
    graphicSettingsTitle: "그래픽 설정",
    screenResolutionLabel: "화면 해상도:",
    playInWindowLabel: "창에서 재생:",
    gammaLabel: "감마:",
    dynamicLightingLabel: "동적 조명:",
    textureDetailLabel: "텍스처 디테일:",
    shadowQualityLabel: "그림자 품질:",
    detailTexturesLabel: "디테일 텍스처:",
    performanceLabel: "성능:",
    gameSettingsTitle: "게임 설정",
    gameLanguageLabel: "게임 언어:",
    proxyServerLabel: "프록시 서버:",
    enableSoundsLabel: "사운드 활성화:",
    enableMusicLabel: "음악 활성화:",
    mouseAccelerationLabel: "마우스 가속:",
    cameraDistanceLabel: "카메라 거리:",
    fovLabel: "FOV:",
    enableTabTargetLabel: "탭 대상 활성화:",
    pvpKillNotificationLabel: "PVP 킬 알림:",
    screenShakeLabel: "화면 흔들기:",
    cancelButton: "취소",
    saveSettingsButton: "설정 저장",
    repairSettingsButton: "수리",
    accountReadyGame: "계정이 이미 인게임 상태입니다. 계속 연결하시겠습니까?",
    accountReadyGameYes: "예",
    accountReadyGameNo: "아니요",
    barChecking: "확인 중",
    barDownloading: "다운로드 중",
    barDownloadSpeed: "다운로드 속도",
    barReady: "준비 완료",
    launcherClose: "런처 닫기",
    launcherCloseTip: "확인란을 선택하면 게임이 시작된 후 런처가 닫힙니다.",

    connectionError3: "계정 금지",
    connectionError4: "잘못된 로그인",
    connectionError5: "잘못된 비밀번호",
    connectionError6: "로그인 서버가 닫혔습니다",
    connectionError7: "네트워크 오류",
    connectionError10: "결제 상태 오류",
    connectionError11: "빈 결과",
    connectionError97: "업데이트 서버에 연결할 수 없습니다.",
    connectionError98: "로그인 서버에 연결할 수 없습니다",
    connectionError99: "선택한 활성 계정이 없습니다",

    sliderTitles: ["News headline 1", "News headline 2", "News headline 3"],
    sliderTexts: [
      "News text. Updates, events, server changes 1",
      "News text. Updates, events, server changes 2",
      "News text. Updates, events, server changes 3",
    ],
    sliderButtons: ["Read News 1", "Read News 2", "Read News 3"],
  },

  // Add more languages and translations as needed
};

// Supported game client languages.
// "Russia", "Europe","Korea","China","Taiwan","Philippines","Indonesia","Thailand","Japan",
export function setLauncherLanguage(value) {
  if (value === "Europe") translate = "en";
  else if (value === "Russia") translate = "ru";
  else if (value === "Korea") translate = "kr";
  else translate = "en";
}

////////////////////////////////////////////////////////////////////////////////////////// Screen Resolution list
export const ScreenSize = [
  "800x600",
  "1024x600",
  "1024x768",
  "1152x864",
  "1280x600",
  "1280x720",
  "1280x768",
  "1280x800",
  "1280x960",
  "1280x1024",
  "1360x768",
  "1400x1050",
  "1440x900",
  "1600x900",
  "1600x1050",
  "1680x1050",
  "1920x1080",
  "1920x1200",
  "2048x1152",
  "2048x1536",
  "2560x1440",
  "2560x1600",
  "3200x2048",
  "3200x2400",
  "3440x1440",
  "3840x2160",
  "4096x2160",
  "5120x4096",
  "6400x4096",
  "6400x4800",
  "7680x4320",
  "7680x4800",
];
